# 第七章 中国开源组织及开源生态现状
 
开源生态是指由开源组织和整个产业界互动形成的、广泛联系的合作平台。中国开源正从早期的使用者、跟随者、参与者，逐渐变成影响者、创作者和贡献者，因此中国开始涌现出越拉越多的开源开发者、开源项目、开源组织和开源企业，而中国首个开源协议“木兰宽松许可证”的诞生和中国首个开源基金会“开放原子开源基金会”的成立，标志着中国开源生态的逐渐完善。尤其是开源首次被写入国家“十四五”规划纲要后，越来越多的人和机构开始讨论开源、了解开源，各级政府部门越来越重视开源，新的开源组织也不断涌现，各种形式的开源活动也越来越频繁，中国开源生态呈现出前所未有的繁荣景象。<br>
 
## 7.1 开源组织发展现状

开源生态的重要组成部分——开源组织一般包括开源企业、开源社区、开源基金会、开源代码托管平台、高校、学术机构以及本土的、民间行业联合体、开源共同体、大公司开源办公室（OSPO）。本书之前章节已分别展现了开源企业、开源社区、开源代码平台等开源组织的发展现状。因此，本章节将着重呈现开源组织中的开源基金会与高校、学术机构以及本土的、民间行业联合体的现状以及中国生态的挑战与机遇。<br>

从全球范围来看，知名的开源组织都有比较鲜明的特征。例如发起了“自由软件运动”的自由软件基金会（FSF），定义了何为“开源”的OSI组织，维护Linux内核生态的Linux基金会，孕育了Kubernetes等明星项目的云原生领域的CNCF基金会，孵化了Apache应用服务器的Apache基金会等。这些成功的基金会和开源组织，几乎毫无例外的都搭建起开放、中立的舞台，让社区领袖带领开发者，通过经年累月的努力与奋斗，掀起技术的浪潮与变革。<br>

随着中国开源软件的快速发展，国内涌现出的越来越多开源组织，积极地为完善中国开源生态做出贡献。例如在国际上颇具影响力的中国开源软件推进联盟（COPU），倡导发展开源芯片的中国开放指令生态 (RISC-V)联盟和中国RISC-V产业联盟，关注开源人工智能等的新一代人工智能产业技术创新战略联盟，聚焦工业 4.0 的开源工业互联网联盟，着力于云计算行业的中国开源云联盟、云计算开源产业联盟等，都彰显了中国开源生态蓬勃发展的生命力。 除了产业型、学术型的开源组织，当前在国内也涌现出一批社区型的开源推广组织，如：开源社、开源中国社区以及ALC（Apache Local Community）北京/深圳等，这些以开源爱好者和志愿者为主体的推广组织，对推动国内的开源知识普及、开源文化推广有巨大的积极意义。国内开源开源组织的发展，经历了借鉴、发展、创新的全历程，下面着重介绍我国的一些重点开源组织。
 
### 7.1.1 开源基金会

**开放原子基金会**<br>

开源基金会是开源生态中的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的商标权，以及与代码相关知识产权的授权，与商业公司没有任何商业利益冲突，这为贡献者、开发者以及用户提供了良好的协作平台。基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库（一般基于第三方平台）、问题跟踪、技术指导、法律支持、项目投资、公共关系维护等，部分基金会还会提供一些公共的平台能力，以辅助项目日常的运营和治理，并满足项目在不同生命周期阶段对于开放治理的需求。目前国际上已有几十家专业的开源基金会在全球的开源生态中发挥着巨大作用，如1985年建立的自由软件基金会（FSF）、1999年创建的Apache基金会、2000年成立的Linux基金会以及2004年成立的Eclipse基金会等。<br>
 
中国开源基金会建设起步较晚，目前中国仅有一家开源基金会-—开放原子开源基金会，于2020年6月经国务院批准成立，基金会第一批成员包括华为、阿里、腾讯、百度、360、浪潮、招商银行等十余家。作为国内首家，也是唯一一家致力于开源产业公益事业的的非营利性独立法人机构，开放原子基金会的成立是一次创新实践，也是中国开源社区发展的重要里程碑，开放原子开源基金会现已正式投入运营，自成立以来备受国内外开源界的关注，并被寄予厚望。<br>
 
开放原子开源基金会现有捐赠单位共44家，其中白金捐赠单位14家、金牌捐赠单位8家、银牌捐赠单位18家、普通捐赠单位4家。<br>

![在这里插入图片描述](https://img-blog.csdnimg.cn/284f1bb8b30949bb882902f4dd304e1a.png#pic_center)<br>*开放原子开源基金会白金捐赠单位*

![在这里插入图片描述](https://img-blog.csdnimg.cn/5b2c061b97ac4800b9d47f331f358f4c.png#pic_center)<br>*开放原子开源基金会金牌捐赠单位*

![在这里插入图片描述](https://img-blog.csdnimg.cn/149904357a5e4e0b91a2f7f3f25da99c.png#pic_center)<br>*开放原子开源基金会银牌捐赠单位*

![在这里插入图片描述](https://img-blog.csdnimg.cn/5603a47871c045da9123df5daa498adc.png#pic_center)<br>*开放原子开源基金会普通捐赠单位*

开放原子开源基金会当前有10个开源项目通过捐赠，正式进入孵化流程，包括：XuperChain、OpenHarmony、 TencentOS Tiny、 TKEStack、 AliOS Things、 PIKA、 UBML、 ZNBase、 快应用、openEuler，覆盖了操作系统、数据库、云原生、嵌入式、区块链、低代码以及应用标准等技术领域。<br>

与此同时，基金户通过旗下的技术监督委员会（简称TOC）已建立起一整套开源技术决策与监督机制，包括：基金会开源项目孵化流程，基金会孵化项目毕业标准1.0等，通过开放、透明的导向来鼓励各开源项目走向社区开放与成熟自治。<br>


### 7.1.2 产业型开源联合体
 
由政府/行业监管机构发起或指导的开源组织。

**中国开源软件推进联盟**<br>

成立于2004年7月22日北京的中国开源软件推进联盟（China OSS Promotion Union，COPU）是在政府主管部门指导下，由致力于开源软件文化、技术、产业、教学、应用、支撑的企业、社区、客户、 大专院校、科研院所、行业协会、支撑机构等组织自愿组成的、民主议事的民间行业联合体，非独立社团法人组织。中国开源软件推进联盟的宗旨是为推动中国开源软件（Linux/OSS）的发展和应用而努力；为促进中日韩以及中国与全球关于开源运动（Linux/OSS）的沟通、交流与合作而努力；为促进全球开源运动（Linux/OSS）做出贡献而努力。<br>

**新一代人工智能产业技术创新战略联盟**

2017年7月23日，为配合新一代人工智能发展规划，支撑人工智能产业技术创新，营造健康有序、充满活力的人工智能应用生态，由北京大学、中关村视听产业技术创新联盟等联合倡议，在科技部试点联盟--数字音视频编解码（AVS）产业技术创新战略联盟的基础上，正式成立新一代人工智能产业技术创新战略联盟。 发起成员单位包括百度、阿里巴巴、腾讯、华为、中兴、京东集团、传化集团、科大讯飞、等知名企业，北京大学、清华大学、浙江大学、北京航空航天大学、等著名高校科研院所以及深行资本、将门投资等投资机构。
 
**中国开源云联盟**<br>

中国开源云联盟（COSCL）成立于2012年8月，在工业和信息化部信息化和软件服务业司指导下，挂靠在中国电子技术标准化研究院，现有我国180余家开源生态圈产、学、研、用成员单位。中国开源云联盟（COSCL）作为国家重点研发计划《云计算和大数据开源社区生态系统》项目的指定开源组织，致力于联合国内开源产业界相关方，在中国共同推动开源生态系统搭建、技术社区建设、开源项目培育、开源团体标准研制、开源技术推广应用、以及开源人才培养等工作，是国内主流活跃的开源技术组织之一。<br>
 
**云计算开源产业联盟**<br>

2016年3月9日，由工业和信息化部信息化和软件服务业司指导，中国信息通信研究院联合多家云计算开源技术公司发起，中国通信标准化协会代管的云计算开源产业联盟（OSCAR）在京召开成立大会。云计算开源产业联盟是业界首个专注于云计算市场的开源产业联盟，旨在推进OpenStack等开源技术在中国的产业化进程，加速中国云计算产业的创新发展。工信部信息化和软件服务业司巡视员李颖、中国信息通信研究院院长曹淑敏、中国通信标准化协会秘书长杨泽民出席会议，来自政府、企业、科研院所的百余位代表见证云计算开源产业联盟成立。<br>
 
**深圳市开放原子开源技术服务中心**

深圳市开放原子开源技术服务中心成立于2020年7月30日，致力于开源技术的开发研究、搭建开源技术的产学研交流平台、提供开源技术服务支持、普及开源文化及知识技术。深圳市开放原子开源技术服务中心是深圳国际开源谷的建设单位之一。深圳国际开源谷是全球首座开源孵化基地，未来，开源谷将积极引入助推产业发展的投资、知识产权交易、开源社区运营、会议培训等配套服务机构，打造多层次立体生态的模式，致力于营造高质量的开源产研协同生态圈，保障软件产业高速发展。

**开源GitOps产业联盟**

2021年5月27日，在中国信息通信研究院云原生产业大会上，极狐与 CNCF)联合发起并成立“开源GitOps产业联盟” (Open GitOps Industry Alliance，OGA联盟）。OGA联盟为进一步推动中国开源、开放GitOps技术在各“产学研”领域的规范化实施和落地，以GitOps技术应用实践为核心，遵守“开源、开放、可信、自主、创新、共赢”的理念，致力于推动开源、开放GitOps技术的产业化发展，着力于构建具备国际技术竞争力、自主可控合作共赢的良好生态。

**“科创中国”开源创新联合体**

“科创中国”联合体2021年1月18日在北京成立。由中国科协科学技术传播中心、中国电子学会、腾讯、百度、麒麟软件、CSDN等36家单位共同发起。联合体以打造自主开源生态为宗旨，以建设产学研深度融合的开源创新体系为目标，以营造中国开源文化、提升开源创新能力为导向，广泛联系开源领域政产学研金介用媒等各类创新主体，汇聚开源创新资源，发展自主开源基金,建设开源实验室、开源社区、开源创新示范基地等新型融合机构，拓展国际科技创新合作，建设“共商、共建、共享、共生、共赢”的科技共同体。截至2022年5月，“科创中国”开源创新联合体理事单位共有37家。

**北京开源创新委员会**

北京开源创新委员会成立于2020年12月,成员包含百度、腾讯、小米、京东、滴滴、地平线、CSDN、统信、PingCAP、中兴等近30家单位。它是在中国开源软件推进联盟、“科创中国”开源创新联合体、北京市科学技术委员会、北京市经济和信息化局、北京科学技术协会指导下由开源企业、开源爱好者发形成的民间公益团体。主要工作内容是发挥北京资源优势，促进开源产业合作、加强开源文化布道、跟进开源深度技术；协助企业开源转型、提升社区开源治理、规避潜在开源风险。

**上海开源信息技术协会**

上海开源信息技术协会是开源创新专业性非营利社会团体法人，成立于2022年3月。协会坚持第三方服务平台定位，立足上海，服务全国。基于自组织创新创业共同体模式，以专业、公开、公正、透明精神，积极发挥企业与政府之间的桥梁和纽带作用，服务国家及上海市数字经济发展战略，推动构建国家“自主、可控”数字经济创新创业公共基础设施。	正在推动的主要工作有：开源理论及方法论构建、中国开源创新社会工程、上海开源产业园区、数字“一带一路”。

### 7.1.3 学术型开源联合体

**CCF开源发展委员会**<br>

2021年12月17日，CCF开源发展委员会正式成立，旨在推动探索学术共同体主导的开源发展新途径，构建产学研项目成果共享孵化机制，加速产教研深度融合的开源生态建设。CCF开源发展委员会将重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，探索建立CCF开源项目孵化机制，培育原始开源创新项目，依托CCF联接科教资源、产业资源和社会资源等，形成产、教、研联动的开源创新模式，推动CCF开源品牌建设和开源社区运营，为CCF会员乃至全球开源创新实践者提供高水平的开源创新服务，助力我国开源生态建设的发展。<br>

**中国RISC-V产业联盟**

2018年9月，中国RISC-V产业联盟成立，聚焦于RISC-V产业落地。它由国内外RISC-V领域重点企业、研究机构、和行业协会发起成立，目前已有50余家RISC-V领域相关企业以及10余家大学和研究机构加入。中国RISC-V产业联盟秉承开放、合作、平等、互利的原则，致力于解决中国RISC-V领域共同面对的关键问题，建立中国国产自主、可控、安全的RISC-V异构计算平台，促进形成贯穿IP 核、芯片、软件、系统、应用等环节的RISC-V 产业生态链。
 
**中国开放指令生态 (RISC-V)联盟**

2018年11月，中国开放指令生态（RISC-V）联盟在世界互联网大会上成立，中国科学院计算所倪光南院士任理事长。该中国开放指令生态（RISC-V）联盟旨在召集从事RISC-V指令集、架构、芯片、软件、整机应用等产业链各环节企事业单位及相关社会团体，自愿组成一个全国性、综合性、联合性、非营利性的社团组织。联盟将围绕RISC-V指令集，以促进开源开放生态发展为目标，以重点骨干企业、科研院所为主体，整合各方资源，通过产、学、研、用深度融合，力图推动协同创新攻关，促进RISC-V相关技术和产品应用推广，探索体制机制创新，推进RISC-V生态在国内的快速发展，从而使我国尽快摆脱核心芯片设计、知识产权、工艺技术等受制于人的不利局面。
 
**中国RISC-V产业联盟**<br>

2018年9月，中国RISC-V产业联盟成立，聚焦于RISC-V产业落地。它由国内外RISC-V领域重点企业、研究机构、和行业协会发起成立，目前已有50余家RISC-V领域相关企业以及10余家大学和研究机构加入。中国RISC-V产业联盟秉承开放、合作、平等、互利的原则，致力于解决中国RISC-V领域共同面对的关键问题，建立中国国产自主、可控、安全的RISC-V异构计算平台，促进形成贯穿IP 核、芯片、软件、系统、应用等环节的RISC-V 产业生态链。<br>
 
**中国开放指令生态 (RISC-V)联盟**<br>

2018年11月，中国开放指令生态（RISC-V）联盟在世界互联网大会上成立，中国科学院计算所倪光南院士任理事长。该中国开放指令生态（RISC-V）联盟旨在召集从事RISC-V指令集、架构、芯片、软件、整机应用等产业链各环节企事业单位及相关社会团体，自愿组成一个全国性、综合性、联合性、非营利性的社团组织。联盟将围绕RISC-V指令集，以促进开源开放生态发展为目标，以重点骨干企业、科研院所为主体，整合各方资源，通过产、学、研、用深度融合，力图推动协同创新攻关，促进RISC-V相关技术和产品应用推广，探索体制机制创新，推进RISC-V生态在国内的快速发展，从而使我国尽快摆脱核心芯片设计、知识产权、工艺技术等受制于人的不利局面。<br>

**上海白玉兰开源开放研究院**

2020年7月11日，上海白玉兰开源开放研究院正式揭牌，上海白玉兰开源开放研究院是由上海交通大学牵头，联合电子中国电子技术标准化研究院、北京大学、机器之心、复旦大学、华东师范大学、开源社、上海人工智能研究院有限公司等单位成立，对标国内外知名开源开放平台，建设世界一流开源开放平台。上海白玉兰开源开放研究院的目标是推动人工智能开源产品的国际规则互认，催生国际开源生态网络关键节点，建立系统验证与合规评测实验室形成国际准。
 
**开源工业互联网联盟**<br>

开源工业互联网联盟（Openii Consortium）成立于2018年12月25日，由工业4.0研究院作为主要发起单位，以帮助中小制造企业实现创新发展为主要目标，采用开源软件和硬件的运行模式，加强利用数字孪生体系列技术来推动开源工业互联网的广泛应用。目前开源工业互联网联盟设有五大板块，分别为参考架构工作组、数字孪生体中心、开源项目中心、INNOBASE VENTURE和知识产权工作组等。工业4.0研究院负责数字孪生体中心的相关研究工作。

### 7.1.4 民间型开源推广组织
 
**开源社**<br>
 
2014年 10月 16日，由中国支持开源的企业、社区及个人所组成的开源联盟“开源社”正式成立，旨在携手国内社区、企业、高校及政府相关机构，共同促进中国开源社区成为全球开源软件的积极参与者和贡献者，并推动开源软件生态体系的健康可持续发展。同时，开源社将致力于促进中国开源软件和开源硬件的正确使用、授权许可、社区建设及管理，并为国内广大开发者提供教育培训、知识普及、工具及相关服务，全面满足中国新兴软件行业日益增长的现实需求。<br>
 
**ALC-Beijing和ALC-Shenzhen**<br>
 
ALC-Beijing和ALC-Shenzhen是遵照Apache软件基金会Local Community原则，并在Apache软件基金会申请并通过的，面向北京和深圳的Apache本地开源社区组织。ALC-Beijing的发起人姜宁为了进一步推动Apache文化在国内的传播，并促进Apache本土项目和开发者的交流和合作，发起该组织，并得到Apache软件基金会的认可。目前该组织包含10多个Apache顶级项目，包括Kylin，Eagle，RocketMQ， ServiceComb，Griffin， SkyWalking，Dubbo，Echarts，APISIX，IotDB，ShardingShpere，DolphinScheduler，Pulsar。至今该组织海内外讲师180+，参与直播人数超过60万。2022年发起人姜宁当选为Apache软件基金会的董事。<br>

**星策开源社区**

星策开源社区是一个聚焦于企业智能化转型，由企事业单位、高等院校、科研单位、非营利性组织等按照自愿、平等、开源、协作的基础上组成的非盈利性中立的开源社区。联合发起单位包括中国开源软件推进联盟（COPU）、信通院、Linux 基金会AI & Data、腾讯、微众银行、第四范式、中兴通讯等。社区的使命是连接企业和AI，以开源的方式共享共建企业智能转型的方法论、案例、实践和技术，助力企业智能化转型成功。

**腾源会**

腾源会是腾讯云成立的汇聚开源项目、开源爱好者、开源领导者的开放社区，致力于帮助开源项目健康成长、开源爱好者能交流协助、开源领导者能发挥领袖价值，让全球开源生态变得更加繁荣。

**开放群岛**

开放群岛（Open Islands）开源社区是由深圳数据交易有限公司联合国家智库、国家单位、高校、大型金融机构、大型互联网公司等近50家发起单位牵头成立的国内首个国际化自主可控隐私计算开源社区。以服务全国数据要素流通应用场景为目标，助力加快建设全国数据交易统一大市场，以开源开放的方式充分整合政府、企业、高校、科研机构等多方资源，推动数据要素流通关键基础技术发展。
 
## 7.2 开源组织的问题与挑战

开源组织中开源基金会等项目托管型的组织较少，而战略智库型、文化建设与推广型的组织较多。出现这种现象的原因，一方面是因为现有的、有较大影响力的国际开源基金会的专业和成熟的平台和机制对国内的企业和开源项目有较大的吸引力；另一方面，由于开源基金会组织设立的门槛较高，涉及到项目的托管与治理，所需要的组织人才需涵盖开源运营、法务、技术开发、企业关系、公共关系等诸多专业领域，建设专业型开源基金会的难度较大。<br>

我国在开源领域起步较晚，稀缺型的专业型开源人才又大多集中在头部的IT和互联网公司，如何吸引优秀的开源人才到开源组织中是一大挑战。<br>
 
## 7.3 开源组织的发展趋势
 
海内外热点的基金会，出现了与行业结合的趋势，即面向重点行业，吸收大型的行业用户单位，鼓励其一起合作来开发成体系的开源解决方案而不仅是单个的开源项目与产品。<br>

在国家政策进一步利好的背景下，越来越多的第三方开源组织涌现出来，通过在中国民政部的全国社会组织信用信息公示平台（xxgs.chinanpo.mca.gov.cn）上查询发现共有12家从事开源相关工作的社会团体、基金会和民办非企业单还处于正常运营中，其中2020年以后成立的就有7家。还有多个依托基金会、学会、联盟、大学等机构的开源组织也于近期纷纷成立，都彰显了国内第三方开源组织蓬勃活力。这些新兴开源组织的成立，必将不断完善着我国的开源生态，为开源产业的发展贡献力量。<br>
 
## 7.4 对开源组织的发展建议

坚守本心。随着近期国际政治与经济领域的冲突加剧，全球各大开源组织都面临一些来自非技术因素（政治、商业等）的压力和干扰。对各大开源组织与社区领袖而言，能否守住初心，即坚持技术中立与开放的开源原则和底线，将面临智慧与定力的双重考验。从实践来看，坚守并践行中立原则的开源基金会与开源组织将赢得开发者以及合作企业的持久信赖。<br>

我们要适当加快国内开源基金会和开源组织的建设，帮助更多的开源项目以及合作企业获得成功，尤其是要注重吸引全球的优秀项目与开发者，要推动形成统一的、你中有我我中有你的开源生态，不要割裂化、碎片化的全球开源生态。<br>

 
## 7.5 国家政策助推中国开源生态发展

### 7.5.1  中国政府大力推进

中国政府一直重视开源的发展，20世纪90年代初拿到了Unix SVR4.2源代码，并推动了Unix(中国)系统技术有限公司的成立，正式启动了中国开源的发展。<br>

20世纪90年代末，中软Linux、红旗Linux、冲浪Linux、蓝点Linux等一批基于开源的操作系统先后发布，得到了政府的极大关注，并以政府采购的方式来支持开源软件，政府采购也成为当时开源软件最主要的市场，并一直持续到现在。<br>

2000年后，为打破国外基础软件的垄断，科技部在“十五”国家重大科技专项中，设立了多个基于开源的科技项目，为当时国内为数不多的几家开源团队提供了关键的研发资金支持，研发出了操作系统、嵌入式操作系统、数据库、办公软件等一批基于开源的基础软件，进一步夯实了中国开源发展基础。<br>

“十一五”期间，2006年国务院发布了《国家中长期科学与技术发展划纲要（2006年-2020年）》，“核心电子器件、高端通用芯片及基础软件产品”（以下简称“核高基”）作为国家16个重大科技专项之一列入其中，实施并一直持续至2020年。通过10余年的实施，极大地推动了国产基础软硬件的发展。<br>

2015年，国务院发布第一个明确包含“开源”内容的政策文件，包含在《国务院办公厅关于发展众创空间推进大众创新创业的指导意见》（国办发〔2015〕9号），提出了“充分运用互联网和开源技术，构建开放创新创业平台，促进更多创业者加入和集聚”。<br>
 
### 7.5.2 开源上升为国家级战略
 
2021年3月11日，十三届全国人大四次会议表决通过了《中华人民共和国国民经济和社会发展第十四个五年规划和 2035 年远景规划纲要》（以下简称《纲要》），开源首次被写入国民经济和社会发展五年规划纲要中，标志着发展开源成为我国十四五期间的重要工作之一。<br>

2021年10月28日，人民银行办公厅、中央网信办秘书局、工业和信息化部办公厅、银保监会办公厅、证监会办公厅联合发布《关于规范金融业开源技术应用与发展的意见》规范金融机构合理应用开源技术，提高应用水平和自主可控能力，促进开源技术健康可持续发展。

2021年11月15日工信部发布的《“十四五”软件和信息技术服务业发展规划》明确提出“建设2-3个有国际影响力的开源社区，培育超过10个优质开源项目”的发展目标，并把“繁荣国内开源生态”作为工作任务，设置“开源生态培育”为专项行动，这是国家级产业规划首次把开源单独作为一个重点工作来部署。这将会对中国开源的未来发展产生非常深远的影响。 <br>
 
### 7.5.3 各省市纷纷出台开源政策，助推开源产业发展
 
依据工信部发布的《2021年软件和信息技术服务业统计公报》中的数据，截至2021年底，2021年全国软件产业收入排名前十的省份发布的政策中有51条支持开源软件，其中27条是在《纲要》出台之后发布的，占比超过50%。<br>

北京市政府一直重视开源软件的发展，国家十四五规划发布以来，北京市发布开源软件支持政策的动作更加密集。初期的支持政策一般包含在对人工智能、区块链、工业互联网以及网络安全的支持政策。<br>

广东是我国ICT产业最发达的省份，同时，深圳、东莞、广州、佛山、中山等地是我国制造业重地。近年随着人工智能、区块链、云计算等开源软件相关产业的迅速发展，广东省也适时发布了相应的支持政策。<br>

江苏省是我国经济排名第二的省份，软件与信息服务业、制造业产值均排在全国各省前列。考虑到开源软件对产业的强力支撑，江苏省近年发布了多条政策，从开源社区、开源组织、开源人才、开源平台、知识产权、基建保障等多个角度对开源软件进行了强有力的支持。<br>

浙江省互联网产业在全国各省市中位居前列，尤其是电子商务产业独树一帜，背后的支撑技术极其受益于开源软件的发展。鉴于开源软件领域还存在知识产权方面等问题，浙江省发布了我国首部开源软件知识产权方面的政策《开源社区知识产权管理规则指引(试行)》，有利于保障开原生态的健康发展。<br>

山东省信息技术产业规模位居全国前列，发展建设了济南人工智能技术创新与产业发展融合集群和济南“1+N+N”大数据生态产业集群，电子信息制造业拥有浪潮集团和潍坊歌尔以及一批知名企业。开源软件产业为这些产业所依托的底层技术提供了有力支撑，山东省鼓励企业等开源组织积极参与国际开源社区，着力于开源软件自下而上地渗透和发展。<br>

上海是我国较早支持和发展开源软件的省市之一。上海市于2015年成立了上海开源大数据研究院，将人工智能作为重点发展的三大先导产业，2020年成立了上海白玉兰开源开放研究院，推动全球开源社区的合作。2021年，上海人工智能实验室对外正式发布了Openxlab的开源AI平台。因此政策重视对开源社区、开源组织的支持以及开源软件人才的培养。<br>

四川省是我国经济强省，2021年四川省GDP在全国各省中排名第六。四川省在电子信息产业发展方面积聚了丰富的资源，近年更是着力聚焦集成电路、网络安全、智能终端等重点领域，加快5G商用步伐，四川省政府充分认识到开源软件对上述产业的促进作用，密集发布了多条政策进行支持。<br>

陕西省是我国较早从事计算机、集成电路及相关产品研发和生产的省份之一，发展至今，陕西省软件产业一直位居全国各省前十。为了促进软件产业的进一步提升、加速产业数字化升级、加快建设数字陕西，陕西省也及时发布了政策对开源社区、开源技术等开源软件要素进行必要的支持。<br>

天津市是我国较早发展软件与信息服务业的省市。现下政策扶持效果显著，骨干企业不断发展壮大，围绕集成电路、操作系统、工业软件等领域突破了一批“卡脖子”技术，形成了一批自主创新成果。<br>

福建省历来重视新一代信息技术产业，并早已认识到开源软件对信息通信、高端软件和新兴信息服务业等新一代信息技术产业领域的巨大促进作用。福建省面向基础软件、工业软件、新兴平台软件、重大装备领域嵌入式软件、重点领域行业专用软件，进一步加强了支持力度，推进经济社会向数字化、智能化转型。<br>
 
## 7.6 中国开源生态的特点
 
**国内积极布局开源生态**<br>

近年来国内企业逐渐侧重基础软件领域开源项目布局，在操作系统、数据库、中间件等基础软件领域涌现多个开源项目。
 
**行业开源生态兴起**<br>

随着我国加快数字化转型的战略布局，政府、医疗、电信、能源、交通物流、制造业在内的众多传统行业也正在不断拥抱开源，开源协作模式在大数据、云计算、人工智能、区块链、物联网等领域加速技术迭代创新。
 
**中国开源开发者增速全球第一**<br>

根据GitHub2021年数据统计：中国开发者数量增长 37%，全球最快。在全球总开发者数量中，美国开发者最多，共有 1355万+； 中国排名第二，共有 755万+；第三是印度，总用户数达到 721万+ 。<br>
 
**开源主题活动激增、内容丰富、形式多样**<br>

随着国家政策环境的持续优化，开源主题活动也逐渐丰富起来，通过对我国最大的会议活动发布平台之一的[活动行](www.huodongxing.com) 的数据整理，发现在2021年我国举办的各类开源主题活动有81场次，同比增长47.27%。这些主题活动包括产业峰会、论坛沙龙、技术培训、开源布道等各种类型，其中线上活动32场次，线下活动49场次，线下活动超过10场次的城市有深圳（16场次）、北京（13场次）、上海（12场次）。这些开源活动的举办，在促进开源资源集聚、推动开源理念普及、激发开源组织凝聚力、调动开发者积极性等方面起到了重要重用，进一步繁荣了我国的开源生态。其中产生较大影响的有：<br>

* **开源中国开源世界高峰论坛** 2021年6月17-18日，由中国开源软件推进联盟主办，赛迪传媒、《软件和集成电路》杂志社联合承办的为期两天的“第16届开源中国开源世界高峰论坛”成功举办。本届论坛以“拥抱开源，缔造创新模式 ”为主题，搭建起了开源领域重要的合作交流和成果展示平台。<br>
* **2021开发者生态峰会-开源专场**：2021年10月20日，北京长风信息技术产业联盟在京主办“2021开发者生态峰会-开源专场”，以“开源赋能 共享生态”为主题，覆盖开源生态、开源技术、开源运营实战、开源社区治理、云原生基础设施等多个方面，在传播开源文化理念、促进开源伙伴合作、推动开源生态建设的同时，也为开发者带来了一场最前沿、最纯粹的开源技术盛宴。<br>
* **OSCAR开源产业大会**：2021年9月17日,OSCAR开源产业大会(2021 OSCAR)在北京正式举行。此次大会由中国信息通信研究院 与中国通信标准化协会联合主办,云计算开源产业联盟承办、云计算标准与开源推进委员会、金融行业开源技术应用社区支持、SegmentFault思否、中国IDC圈、开源社、开源之道共同协办。大会旨在进一步探索我国开源生态发展模式,加速开源技术在国内市场落地,推动国内开源生态快速、健康有序发展。<br>
* **2021中国软件产业年会开源软件创新发展论坛**：2021年4月7日，由中国软件行业协会、开放原子开源基金会共同举办的“2021中国软件产业年会开源软件创新发展论坛”在北京召开。本次大会以探讨软件开源方向，探讨如何更高更快更开放地推动开源项目发展。以更先进的开源协作创新模式，加入制造强国、网络强国、数字中国和智慧社会建设。<br>
* **OpenInfra Days China 2021**：2021年10月15-16日，OpenInfra Days China 2021在北京成功举办。本届大会主题为“开源基础设施的下一个十年”，全球知名企业技术专家和行业领袖，与听众分享开源基础设施技术的最新进展及探索路径。<br>
* **长沙·中国1024程序员节**：2021年10月23日，第二届“长沙 · 中国1024程序员节”在湖南长开幕。大会以“开源开放、算据赋能——开启数字经济新时代”为主题，研讨议题包括数字新基建、数据库技术实践与未来、先进计算与人工智能技术、工业互联网智能制造、隐私计算与大数据、智能汽车、全场景AI、云原生时代、长沙智谷项目推介会等。<br>
 
 
## 7.7 开源生态发展的问题与挑战
 
**现有高校人才培养机制，与当前开源生态存在矛盾和鸿沟。**<br>

目前我们国家的政策导向，反映出开源软件生态的蓬勃兴起，这是环境推动的结果。但我国开源生态起步较晚，开源领域人才规模比较小，企业参与多，高校参与相对少，学生的重视度目前还不够。并且学校的产教融合也不够深入，参与开源体系当中项目与活动数量都不足。
 
**开源商业化问题影响长期投入。**<br>

据开源中国统计，2021年国内开源投融资金额达到历史最高水平，为52亿元，同比增长86%，数据技术、云原生、AI均是热门赛道。但中国开源商业化现状是开发者规模快速增长，但过半未从中获得收入。如何让更多开发者从开源中赚到钱，可能是中国开源项目未来需要面对的问题。如果没有商业化的动力，团队和个人将很难长期来维护和迭代开源项目。
 
**开源代码安全与开源治理问题紧迫。**<br>

随着开源组件的不断增多，大量的第三方开源组件被放到软件中，导致软件供应链变得越来越复杂，安全风险也前所未有的严峻。去年一系列开源安全问题引发的时间引发高度关注，开源趋势下，有了更高的安全需求。
 
## 7.8 开源生态发展趋势与建议
 
**加强开源实践教育，培养开源创新人才。**<br>

为我国开源事业的健康发展打下坚实的人才基础。开源发展的根基在于大规模的开源创新人才，充分发挥国内开放的开源组织和开源平台的力量，联合来自产业界和开源社区有丰富实践经验的一线开源专家，面向高校的开源开发者和社会上的开源爱好者。宣传推广开源文化，探索开源实践教学的模式，为我国开源创新的持续健康发展提供人才基础。<br>
 
**大力发展立足中国、面向全球的开源组织与创新平台。**<br>

我国已经成为国际开源社区发展最活跃的力量，主动构建开源软件生态，发布开源的根项目，并发挥我们统一大市场和高端软件人才的优势，引导市场主体和开源开发者拥抱原发于我国的开源软件，让更多的优质开源项目在中国生长繁茂，并走向世界。<br>
 
**建立符合我国特点的开源发展路径。**<br>

我国成立了首家开源基金会开放原子开源基金会，同时还成立了一大批开源组织、社区等，探索开源发展的路径，但当前的开源发展路径仍是从国外的吸取经验，未来探索出一条符合我国国情的开源发展的路径是至关重要的。
